<?php

// Exit if accessed directly
if ( !defined( 'ABSPATH' ) ) {
    exit;
}

global $wpdb;
global $pwbe_sql_builder;

ob_implicit_flush(true);
ob_end_flush();

$products = $pwbe_sql_builder->get_products( $_POST );
$views = PWBE_Views::get();

$product_columns = PWBE_Columns::get();

$hidden_columns = array();
$selected_view = get_option( 'pwbe_selected_view', 'pwbeview_all' );
if ( isset( $views[ $selected_view ] ) ) {
    $hidden_columns = $views[ $selected_view ];
}

if ( function_exists( 'wc_get_price_thousand_separator' ) ) {
    $price_thousand_separator = wc_get_price_thousand_separator();
} else {
    $price_thousand_separator = stripslashes( apply_filters( 'wc_get_price_thousand_separator', get_option( 'woocommerce_price_thousand_sep' ) ) );
}

if ( function_exists( 'wc_get_price_decimal_separator' ) ) {
    $price_decimal_separator = wc_get_price_decimal_separator();
} else {
    $price_decimal_separator = apply_filters( 'wc_get_price_decimal_separator', get_option( 'woocommerce_price_decimal_sep' ) );
    $price_decimal_separator = $price_decimal_separator ? stripslashes( $price_decimal_separator ) : '.';
}

if ( function_exists( 'wc_get_price_decimals' ) ) {
    $price_decimals = wc_get_price_decimals();
} else {
    $price_decimals = absint( apply_filters( 'wc_get_price_decimals', get_option( 'woocommerce_price_num_decimals', 2 ) ) );
}

?>
<input type="hidden" id="pwbe-price-thousand-separator" value="<?php echo $price_thousand_separator; ?>" />
<input type="hidden" id="pwbe-price-decimal-separator" value="<?php echo $price_decimal_separator; ?>" />
<input type="hidden" id="pwbe-price-decimal-places" value="<?php echo $price_decimals; ?>" />
<div id="pwbe-results-error" class="pwbe-error pwbe-hidden"></div>
<div id="pwbe-results-container">
<?php
    if ( !is_string( $products ) ) {
        if ( PWBE_DB::num_rows( $products ) > 0 ) {
            ?>
            <p class="pwbe-results-buttons">
                <div id="pwbe-records-found"></div>

                <button id="pwbe-product-save-button" class="button button-primary" title="<?php _e( 'Save Products', 'pw-bulk-edit' ); ?>" disabled="disabled"><i class='fa fa-floppy-o fa-fw' aria-hidden='true'></i> <?php _e( 'Save Changes', 'pw-bulk-edit' ); ?></button>
                <!--// <button id="pwbe-product-fix-attributes-button" class="button button-secondary" title="Fix Attributes"><i class='fa fa-wrench fa-fw' aria-hidden='true'></i> Fix Attributes</button> //-->
                <button id="pwbe-product-undo-button" class="button button-secondary pwbe-product-undo-button" title="<?php _e( 'Undo', 'pw-bulk-edit' ); ?>" disabled="disabled"><i class='fa fa-undo fa-fw' aria-hidden='true'></i></button>
                <button id="pwbe-product-redo-button" class="button button-secondary" title="<?php _e( 'Redo', 'pw-bulk-edit' ); ?>" disabled="disabled"><i class='fa fa-repeat fa-fw' aria-hidden='true'></i></button>
                <button id="pwbe-product-discard-button" class="button pwbe-button-red" title="<?php _e( 'Discard All Changes', 'pw-bulk-edit' ); ?>" disabled="disabled"><i class='fa fa-refresh fa-fw' aria-hidden='true'></i></button>

                <span class="pwbe-results-button-container">
                    <button id="pwbe-product-export-csv" class="button button-secondary" title="<?php esc_attr_e( 'Export results as CSV file', 'pw-bulk-edit' ); ?>"><i class='fa fa-file-text-o fa-fw' aria-hidden='true'></i> <?php esc_html_e( 'Export CSV', 'pw-bulk-edit' ); ?></button>
                </span>

                <span class="pwbe-results-button-container">
                    <strong><?php _e( 'View', 'pw-bulk-edit' ); ?> </strong>
                    <select id="pwbe-view" name="pwbe_view">
                        <?php
                            foreach( $views as $key => $value ) {
                                $view = htmlspecialchars( $key, ENT_COMPAT );
                                $view_name = $view;

                                if ( $view == 'pwbeview_all' ) {
                                    $view_name = __( 'All Columns', 'pw-bulk-edit' );
                                } else if ( $view == 'pwbeview_default' ) {
                                    $view_name = __( 'Standard Columns', 'pw-bulk-edit' );
                                }

                                echo "<option value=\"$view\" " . selected( $selected_view, $key, false ) . ">$view_name</option>\n";
                            }

                        ?>
                    </select>
                    <span id="pwbe-view-copy" class="pwbe-link pwbe-filter-toolbar-button" title="<?php _e( 'Copy View', 'pw-bulk-edit' ); ?>"><i class="fa fa-files-o fa-fw"></i></span>
                    <span id="pwbe-view-edit" class="pwbe-link pwbe-filter-toolbar-button <?php if ( empty( $selected_view ) || PW_Bulk_Edit::starts_with( 'pwbeview_', $selected_view ) ) { echo 'pwbe-hidden'; } ?>" title="<?php _e( 'Edit View', 'pw-bulk-edit' ); ?>"><i class="fa fa-pencil-square-o fa-fw"></i></span>
                    <span id="pwbe-view-delete" class="pwbe-link pwbe-filter-toolbar-button <?php if ( empty( $selected_view ) || PW_Bulk_Edit::starts_with( 'pwbeview_', $selected_view ) ) { echo 'pwbe-hidden'; } ?>" title="<?php _e( 'Delete View', 'pw-bulk-edit' ); ?>"><i class="fa fa-trash-o fa-fw"></i></span>
                </span>

                <div id="pwbe-auto-create-variations-container" class="pwbe-hidden">
                    <input type="checkbox" id="pwbe-auto-create-variations" name="auto_create_variations" value="1" <?php checked( get_option( 'pwbe_auto_create_variations' ), '1' ); ?>>
                    <label for="pwbe-auto-create-variations"><?php _e( 'Automatically create Variations from Attributes added to Variable Products.', 'pw-bulk-edit' ); ?></label> [<a href="#" onClick="alert('<?php _e( 'When adding Attributes to Variable products, check this box to automatically create the appropriate Variations. This checkbox will have no effect if the product is not a Variable product or if you are removing Attributes.', 'pw-bulk-edit' ); ?>'); return false;">?</a>]

                    <div id="pwbe-auto-create-variations-new-attr-only-container" class="<?php if ( get_option( 'pwbe_auto_create_variations' ) != '1' ) { echo 'pwbe-hidden'; } ?>">
                        <input type="checkbox" id="pwbe-auto-create-variations-new-attr-only" name="auto_create_variations_new_attr_only" value="1" <?php checked( get_option( 'pwbe_auto_create_variations_new_attr_only', '0' ), '1' ); ?>>
                        <label for="pwbe-auto-create-variations-new-attr-only"><?php _e( 'Only create Variations for newly added Attributes.', 'pw-bulk-edit' ); ?></label> [<a href="#" onClick="alert('<?php _e( 'When new Attributes are added, a Variation will be created for each Attribute that has Used For Variations selected. Check this box to only create the Variations with the newly added Attribute.', 'pw-bulk-edit' ); ?>'); return false;">?</a>]
                    </div>
                </div>
                <?php do_action( 'pw_bulk_edit_results_buttons' ); ?>
            </p>
            <form id="pwbe-results-form">
                <div class="pwbe-table pwbe-results-table">
                    <div id="pwbe-header-fixed" class="pwbe-thead"></div>
                    <div id="pwbe-header-results" class="pwbe-thead">
                        <div class="pwbe-tr">
                            <div class="pwbe-td pwbe-results-table-td pwbe-results-table-header-td pwbe-row-checkbox"><input type="checkbox" class="pwbe-checkall" checked="checked" /></div>
                            <div class="pwbe-td pwbe-results-table-td pwbe-results-table-header-td pwbe-view-in-woo">&nbsp;</div>
                            <?php
                                do_action( 'pwbe_before_column_headers' );

                                foreach ( $product_columns as $column ) {
                                    if ( $column['visibility'] != 'none' ) {

                                        if ( in_array( $column['field'], $hidden_columns ) ) {
                                            $hidden = 'pwbe-hidden-column pwbe-hidden';
                                        } else {
                                            $hidden = '';
                                        }

                                        if ( !isset( $column['sortable'] ) ) {
                                            $column['sortable'] = true;
                                        }

                                        if ( !isset( $column['readonly'] ) ) {
                                            $column['readonly'] = false;
                                        }

                                        echo "
                                            <div class='pwbe-td pwbe-results-table-td pwbe-results-table-header-td $hidden' data-field='$column[field]'>
                                                <span class='pwbe-header' data-type='$column[type]' data-field='$column[field]' data-readonly='$column[readonly]' data-sortable='$column[sortable]'>$column[name]</span>&nbsp;";

                                                if ( $_POST['order_by'] == $column['field'] ) {
                                                    if ( empty( $_POST['order_by_desc'] ) ) {
                                                        echo "<i class='fa fa-sort-asc' aria-hidden='true'></i>";
                                                    } else {
                                                        echo "<i class='fa fa-sort-desc' aria-hidden='true'></i>";
                                                    }
                                                }

                                        echo '</div>';
                                    }
                                }

                                do_action( 'pwbe_after_column_headers' );
                            ?>
                        </div>
                    </div>
                    <div class="pwbe-tbody">
                        <?php

                            $max_results = get_option( 'pwbe_max_results', false );
                            if ( false === $max_results || !is_numeric( $max_results ) ) {
                                $max_results = PWBE_MAX_RESULTS;
                            }

                            $i = 0;
                            $result_limit_exceeded = false;

                            global $pwbe_product;

                            while ( $pwbe_product = PWBE_DB::fetch_object( $products ) ) {
                                if ( $i > $max_results ) {
                                    $result_limit_exceeded = true;
                                    break;
                                } else {
                                    $i++;
                                }

                                $pwbe_sql_builder->load_extended_pwbe_product_data();

                                ?>
                                <div class="pwbe-tr pwbe-product-tr pwbe-product-tr-selected <?php if ( $pwbe_product->product_type == 'variation' ) { echo 'pwbe-tr-variation'; } else { echo 'pwbe-tr-product'; } ?>">
                                    <div class="pwbe-td pwbe-results-table-td pwbe-row-checkbox"><input class="pwbe-product-checkbox" id="pwbe-product-<?php echo $pwbe_product->post_id; ?>" name="post[]" type="checkbox" value="<?php echo $pwbe_product->post_id; ?>" checked="checked"></div>
                                    <div class="pwbe-td pwbe-results-table-td pwbe-view-in-woo">
                                        <?php
                                            if ( $pwbe_product->product_type != 'variation' ) {
                                                ?>
                                                <a class="pwbe-view-in-woo-link" target="_blank" title="<?php _e( 'View Product in WooCommerce', 'pw-bulk-edit' ); ?>" href="<?php echo get_edit_post_link( $pwbe_product->post_id, 'edit' ); ?>"><i class="fa fa-external-link fa-fw" aria-hidden="true"></i></a>
                                                <?php
                                            }
                                        ?>
                                    </div>
                                    <?php
                                        do_action( 'pwbe_before_columns' );

                                        $pwbe_product = apply_filters( 'pwbe_results_product_initial', $pwbe_product );

                                        foreach ( $product_columns as $column ) {
                                            if ( $column['visibility'] != 'none' ) {

                                                if ( ! in_array( $column['field'], $hidden_columns ) ) {
                                                    $pwbe_product = apply_filters( 'pwbe_results_product', $pwbe_product, $column );
                                                    echo pwbe_field( $pwbe_product, $column );
                                                }
                                            }
                                        }

                                        do_action( 'pwbe_after_columns' );
                                    ?>
                                </div>
                                <?php
                            }

                            PWBE_DB::free_result( $products );
                        ?>
                        <script>
                            <?php
                                if ( true === $result_limit_exceeded ) {
                                    ?>
                                    jQuery('#pwbe-records-found').html('<?php printf( __( 'Maximum %s records found', 'pw-bulk-edit' ), number_format( $max_results ) ); ?> [<a href="#" onClick="alert(\'<?php _e( 'Go to the Settings page if you would like to increase this limit. NOTE: this limit is in place due to browser limitations. Increasing this value may cause unexpected behavior! Instead, we suggest adding additional filters to lower the number of products found.', 'pw-bulk-edit' ); ?>\'); return false;">?</a>] ');
                                    <?php
                                } else {
                                    ?>
                                    jQuery('#pwbe-records-found').html('<?php printf( __( '%s records found', 'pw-bulk-edit' ), number_format( $i ) ); ?>');
                                    <?php
                                }
                            ?>
                        </script>
                    </div>
                </div>
            </form>
            <div id="pwbe-bulkedit-dialog" class="pwbe-dialog" tabindex="0">
                <div class="pwbe-dialog-heading">
                    <i class="fa fa-database"></i> <?php _e( 'Bulk Edit', 'pw-bulk-edit' ); ?> <span class="pwbe-bulkedit-field-name"></span>
                </div>
                <div class="pwbe-dialog-container">
                    <p>
                        <?php _e( 'The Bulk Editor will make changes to all checked items in the grid.', 'pw-bulk-edit' ); ?>
                    </p>
                    <?php
                        require_once( 'bulk_editors/checkbox.php' );
                        require_once( 'bulk_editors/currency.php' );
                        require_once( 'bulk_editors/date.php' );
                        require_once( 'bulk_editors/image.php' );
                        require_once( 'bulk_editors/images.php' );
                        require_once( 'bulk_editors/multiselect.php' );
                        require_once( 'bulk_editors/number.php' );
                        require_once( 'bulk_editors/select.php' );
                        require_once( 'bulk_editors/text.php' );
                        require_once( 'bulk_editors/textarea.php' );
                    ?>
                    <div class="pwbe-dialog-button-container">
                        <button id="pwbe-bulkedit-dialog-button-apply" class="button button-primary pwbe-dialog-button-apply"><?php _e( 'Apply', 'pw-bulk-edit' ); ?></button>
                        <button id="pwbe-bulkedit-dialog-button-cancel" class="button button-secondary pwbe-dialog-button-cancel"><?php _e( 'Cancel', 'pw-bulk-edit' ); ?></a>
                    </div>
                </div>
            </div>
            <?php
        } else {
            ?>
            <h3><?php _e( 'No products found matching the filter criteria.', 'pw-bulk-edit' ); ?> <i class="fa fa-frown-o" aria-hidden="true"></i></h3>
            <?php
        }
    } else {
        ?>
        <div class="pwbe-filter-error-heading"><?php printf( __( 'There was an error while filtering. Please send an email to %s with the following information:', 'pw-bulk-edit' ), '<a href="mailto:us@pimwick.com">us@pimwick.com</a>' ); ?></div>
        <div class="pwbe-filter-error-message"><?php echo $products; ?></div>
        <?php
    }
?>
</div>
<div id="pwbe-edit-view-dialog" class="pwbe-dialog">
    <div class="pwbe-dialog-heading">
        <i class="fa fa-filter"></i> <span class="pwbe-filter-manager-dialog-name"><?php _e( 'Edit View', 'pw-bulk-edit' ); ?></span>
        <a href="#" id="pwbe-edit-view-dialog-button-cancel" class="pwbe-dialog-close-x">X</a>
    </div>
    <div class="pwbe-dialog-container">
        <?php
            require( dirname( __FILE__ ) . '/view_manager/edit.php' );
        ?>
    </div>
</div>
<?php
